;/*************************************************************************
; Program			:Measure temperature with the DS1820
; Description		:the temperature data will be send to serial port(RS232). 
; Pin description	:DQ = PB0
; CPU Control		:90S8535
; File name			:DS1820.asm
; Assembler			:AVR Studio 4.05
; 
;**************************************************************************

.include "8535def.inc"			

			.org   	$000 
    		rjmp  reset					;Reset Handle

;/******************
; Define Register
;/******************
.def		digit3		= r12
.def		digit2		= r13
.def		digit1		= r14
.def		drem8u		= r15
.def		counter1  	= r16
.def		counter2	= r17
.def		counter3	= r18
.def		temp		= r19
.def		temp1		= r20
.def		Onewire_Data	= r21
.equ		ONE_WIRE	= 0				;DQ = PB.0

;/******************
; Main Program
;/******************
reset:     	ldi	temp,low(RAMEND)
            out	SPL,temp          		;init Stack Pointer     
            ldi	temp,high(RAMEND)
            out	SPH,temp
			ser	temp
			sbi	DDRB,ONE_WIRE
			sbi	PORTB,ONE_WIRE

main:		sbi	UCR,TXEN
			ldi	temp,51					;9600 bps, f = 8 MHz 
			out	UBRR,temp
			ldi	ZH,high(2*DS1820TB)
			ldi	ZL,low(2*DS1820TB)
			rcall	Intro

Loop:		rcall	ONEWIRE_RST
			ldi	Onewire_Data,$CC		;skip rom command
			rcall	ONEWIRE_WR				
			ldi	Onewire_data,$44		;Convert temperature command
			rcall	ONEWIRE_WR
			rcall	ONEWIRE_RST
			ldi	Onewire_Data,$CC		;skip rom command
			rcall	ONEWIRE_WR
			ldi	Onewire_Data,$BE		;read scratchpad command
			rcall	ONEWIRE_WR		
			rcall	ONEWIRE_RD			;Get data
			rcall	ONEWIRE_RST

			clc
			set
			ror	Onewire_Data
			brcs	conv_t
			clt
conv_t:		rcall	Hex_to_BCD			;convert hexadecimal to bcd
			mov	Onewire_Data,digit3
			cpi	Onewire_Data,$31
			breq	send_digit3			;digit 100
			ldi	Onewire_Data,0
send_digit3:
			rcall	TX_Byte
			mov	Onewire_Data,digit2		;digit 10
			rcall	TX_Byte
			mov	Onewire_Data,digit1		;digit 1
			rcall	TX_Byte
			ldi	Onewire_Data,'.'		;.
			rcall	TX_Byte
			ldi	Onewire_Data,'5'
			brts	Send
			ldi	Onewire_Data,'0'
Send:		rcall	TX_Byte
			ldi	Onewire_Data,' '
			rcall	TX_Byte
			ldi	Onewire_Data,'C'
			rcall	TX_Byte
			ldi	Onewire_Data,0x0D	
			rcall	TX_Byte
			rcall	delay200ms
			rjmp	Loop					

;/******************************************
;/	1WIRE reset and presence pulse
;/******************************************
ONEWIRE_RST:
			cbi	PORTB,ONE_WIRE
			ldi	temp1,13
			rcall	delayx50us
			sbi	PORTB,ONE_WIRE
			ldi	temp1,45
			rcall	delayx1us
Wait_Pres:	sbic	PINB,ONE_WIRE		
			rjmp	Wait_Pres
Wait_Pres1:	sbis	PINB,ONE_WIRE
			rjmp	Wait_Pres1
			ret		

;/************************************
;/	write data 1 byte
;/	output:	Onewire_Data
;/************************************
ONEWIRE_WR:	ldi	counter1,8			;write 8 bit
Sub_1WireWR:	
			cbi	PORTB,ONE_WIRE
			ldi	temp1,2
			rcall	delayx1us
			ror	Onewire_Data		;LSB frist out
			brcc	Sub_1WireWR_1
			sbi	PORTB,ONE_WIRE
Sub_1WireWR_1:
			ldi	temp1,65
			rcall	delayx1us
			sbi	PORTB,ONE_WIRE
			ldi	temp1,2
			rcall	delayx1us
			dec	counter1
			brne	Sub_1WireWR
			ret
				
;/*********************************************
;/	Read data 1 byte
;/	input:	Onewire_Data 
;/*********************************************
ONEWIRE_RD:	ldi	counter1,8			;read 8 bit
Sub_1WireRD:
			cbi	PORTB,ONE_WIRE
			ldi	temp1,2
			rcall	delayx1us
			sbi	PORTB,ONE_WIRE
			ldi	temp1,4
			rcall	delayx1us
			clc
			sbic	PINB,ONE_WIRE
			sec
			ror	Onewire_Data
			ldi	temp1,45
			rcall	delayx1us
			dec	counter1
			brne	Sub_1WireRD
			ret

;/*********************************************
;/ convert data from hexcode to BCD code
;/ input : Onewire_data
;/ output: digit3,2,1
;/*********************************************
Hex_to_BCD: mov	temp,Onewire_data		
			ldi	temp1,100
			rcall	Divide8u		;temp:drem8u=Onewire_data/100
			subi	temp,-$30		;temp = temp + 0x30
			mov	digit3,temp
	
			mov	temp,drem8u
			ldi	temp1,10
			rcall	Divide8u		;temp:drem8u=Onewire_data/10
			subi	temp,-$30
			mov	digit2,temp
		
			mov	temp1,drem8u
			subi	temp1,-$30
			mov	digit1,temp1
			ret

;/********************************
;/ divide 8/8 unsign
;/ result/dividend : temp
;/ remainder	   : drem8u
;/ divisor	   : temp1
;/********************************	
Divide8u:	push	counter3
			sub	drem8u,drem8u		;clear register and carry
			ldi	counter3,9
d8u_1:		rol	temp				;shift out MSB to carry flag
			dec	counter3
			brne	d8u_2
			pop	counter3
			ret

d8u_2:		rol	drem8u				;shift get carry flag into LSB 
			sub	drem8u,temp1
			brcc	d8u_3			;if temp1 > drem8u do nothing
			add 	drem8u,temp1
			clc
			rjmp	d8u_1
d8u_3:		sec
			rjmp	d8u_1
		
;/*********************
;/ Display data
;/*********************
Intro:		lpm
			tst	r0
			breq	end_sub
TX232:		sbis	USR,UDRE
			rjmp	TX232
			out	UDR,r0
			adiw	ZL,1
			rjmp	Intro
end_sub:	ret		

TX_Byte:	sbis	USR,UDRE
			rjmp	TX_Byte
			out	UDR,Onewire_Data
			ret

;/***************************************************
;/ delay time
;/ Note: These delay Programs use frequency = 8 mhz
;/***************************************************
delayx1us:	push	counter1
			mov	counter1,temp1
delayx1us_1:
			push	counter1
			pop	counter1
			nop
			dec	counter1
			brne	delayx1us_1
			pop	counter1
			ret

delayx50us:	push	counter1
			push	counter2
			mov	counter1,temp1
delayx50us_1:	
			ldi	counter2,100
delayx50us_2:	
			nop
			dec	counter2
			brne	delayx50us_2
			dec	counter1
			brne	delayx50us_1
			pop	counter2
			pop	counter1
			ret

delay1ms:	push	counter1
			push	counter2
			ldi	counter1,8
delay1ms_1: ldi counter2,250
delay1ms_2: nop
			dec counter2
            brne   	delay1ms_2
            dec    	counter1
            brne   	delay1ms_1
            pop	counter2
			pop	counter1
			ret          

delay200ms:	push	counter3
			ldi	counter3,200
delay200ms_1:	
			rcall	delay1ms
			dec	counter3
			brne	delay200ms_1
			pop	counter3
			ret


;/******************
; code segment
;/******************
DS1820TB:	.db	0x0a,0x0d,"Measure temperature with DS1820. ",0x0a,0x0d,0           	 